/*
 * @(#)ZipDirectoryExtracting.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JDialog;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.ScrollPaneConstants;
import com.sun.java.swing.JButton;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JTextField;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.awt.Frame;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Dimension;
import java.awt.Point;

import java.io.File;
import java.io.IOException;

import java.util.Vector;


/**
 * This class is use to select the directory where extract the files
 * @see ZipTable
 * @see ZipButton
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipDirectoryExtracting extends JDialog {
    
    // private members
    private JScrollPane scrollPane;
    private ZipTable zipTable;
    private ZipButton upButton;
    private ZipButton newFolderButton;
    private Vector files;
    private String currentDirectory;
    private JComboBox comboBox;
    private Vector result;
    private Frame owner;

    // public members
    public int positionInPathName;
    public boolean canceled;

    /**
     * Constructor of the class, initialize all the components
     * @param owner the frame which intanciate the Dialog
     */
    public ZipDirectoryExtracting(Frame owner) {
	super(owner,"Chose the directory to extract archives",true);
	this.owner = owner;

	canceled = false;

	/**
	 * This class is used to activate the closing cross
	 * @version 1.0
	 * @author Frank Moisant - Patrick Titiano
	 */
	addWindowListener(new WindowAdapter() {

	    /**
	     * Use when window is closing
	     * @param e the window event
	     */
	    public void windowClosing(WindowEvent e) {
		zipTable.clearSelection();
		canceled = true;
	    }
	});
	
	// initialize members
	result = new Vector();
	ButtonListener buttonListener = new ButtonListener();
	files = new Vector();
	Vector name = new Vector();
	name.addElement("Directory list");
	zipTable = new ZipTable(files,name);
	zipTable.addMouseListener(new MouseListener());
	zipTable.setSelectionMode(com.sun.java.swing.ListSelectionModel.SINGLE_SELECTION);

	// initilize the drive vector
	Vector Lecteurs = new Vector();
	Lecteurs.addElement("A:"+ File.separator);
	Lecteurs.addElement("B:"+ File.separator);
	Lecteurs.addElement("C:"+ File.separator);
	Lecteurs.addElement("D:"+ File.separator);
	Lecteurs.addElement("E:"+ File.separator);
	Lecteurs.addElement("F:"+ File.separator);
	Lecteurs.addElement("G:"+ File.separator);
	Lecteurs.addElement("H:"+ File.separator);
	Lecteurs.addElement("I:"+ File.separator);
	Lecteurs.addElement("J:"+ File.separator);
	Lecteurs.addElement("K:"+ File.separator);
	Lecteurs.addElement("L:"+ File.separator);
	Lecteurs.addElement("M:"+ File.separator);
	Lecteurs.addElement("N:"+ File.separator);
	Lecteurs.addElement("O:"+ File.separator);
	Lecteurs.addElement("P:"+ File.separator);
	Lecteurs.addElement("Q:"+ File.separator);
	Lecteurs.addElement("R:"+ File.separator);
	Lecteurs.addElement("S:"+ File.separator);
	Lecteurs.addElement("T:"+ File.separator);
	Lecteurs.addElement("U:"+ File.separator);
	Lecteurs.addElement("V:"+ File.separator);
	Lecteurs.addElement("W:"+ File.separator);
	Lecteurs.addElement("X:"+ File.separator);
	Lecteurs.addElement("Y:"+ File.separator);
	Lecteurs.addElement("Z:"+ File.separator);

	// the combo box to choose the drive
	comboBox = new JComboBox(Lecteurs) {
	    public boolean isEditable() {
		return false;
	    }
	};
	comboBox.setMaximumRowCount(3);
	comboBox.setActionCommand("DRIVE");
	comboBox.addActionListener(buttonListener);

	// scrollpane for the table
	scrollPane = new JScrollPane(zipTable, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				     ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	scrollPane.setBackground(Color.white);
	scrollPane.setAutoscrolls(true);

	// the button to go to the previous folder
	upButton = new ZipButton("UP","images" + File.separator + "previous.gif");
	upButton.addActionListener(buttonListener);
	upButton.setToolTipText("Parent directory");

	// the button to create a new folder
	newFolderButton = new ZipButton("CREATE","images" + File.separator + "new_folder.gif");
	newFolderButton.addActionListener(buttonListener);
	newFolderButton.setToolTipText("Create new directory");

	JPanel panelNorth = new JPanel();
	panelNorth.setLayout(new FlowLayout(FlowLayout.LEFT));
	panelNorth.add(new JLabel("Select a drive:"));
	panelNorth.add(comboBox);
	panelNorth.add(upButton);
	panelNorth.add(newFolderButton);

	// the ok-cancel buttons
	JPanel panelSouth = new JPanel();
	panelNorth.setLayout(new FlowLayout(FlowLayout.CENTER));
	
	JButton okButton = new JButton("OK");
	okButton.setActionCommand("OK");
	okButton.addActionListener(buttonListener);

	JButton cancelButton = new JButton("Cancel");
	cancelButton.setActionCommand("CANCEL");
	cancelButton.addActionListener(buttonListener);

	panelSouth.add(okButton);
	panelSouth.add(cancelButton);

	getContentPane().add("North",panelNorth);
	getContentPane().add("Center",scrollPane);
	getContentPane().add("South",panelSouth);

	// prepare and display the dialog
	pack();
	setSize(300,300);
	Dimension dim = owner.getSize();
	Point loc = owner.getLocation();
	Dimension curdim = getSize();
	setLocation(loc.x + dim.width/2 - curdim.width/2, loc.y + dim.height/2 - curdim.height/2);

	// the current path is set
	File directory = new File(".");
	String tmpDir = directory.getAbsolutePath();
	currentDirectory = tmpDir.substring(0,tmpDir.length()-2); // path without \. at the end
	setPath(currentDirectory); // to print the first time
	setVisible(true);
    }


    /**
     * set the path to display
     * @param path the path to display
     */
    public void setPath(String path) {

	// current directory
	File file = new File(path);

	// files in the path
	String tab[] = file.list();
	files.removeAllElements();
	for(int i = 0; i < tab.length; i++) {
	    Vector row = new Vector();
	    String fullname = tab[i];
	    String extension = "directory";
	    File verifyDir = new File(path + File.separator +  tab[i]);
	    if(verifyDir.isDirectory()) {
		row.addElement(fullname);
		row.addElement(extension);
		
		files.addElement(row);
	    }
	}
	TableModelEvent tme = new TableModelEvent(zipTable.getModel());
	zipTable.tableChanged(tme);
	zipTable.clearSelection();
    }


    /**
     * Method calls when the window manager want to resize th Dialog
     * @return always false
     */
    public boolean isResizable() {
	return false;
    }

    /**
     * Internal class implement Action Listener for button and combo box actions
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    private class ButtonListener implements ActionListener {

	/**
	 * called when an action on the button or combo box arrive
	 * @param e the action event
	 */
	public void actionPerformed(ActionEvent e) {
	    String theAction = e.getActionCommand();

	    // previous directory
	    if(theAction.equals("UP")) {
		int lastSeparatorIndex = currentDirectory.lastIndexOf(File.separator);
		int firstSeparatorIndex = currentDirectory.indexOf(File.separator);
		if(lastSeparatorIndex == firstSeparatorIndex) {
		    lastSeparatorIndex++;
		}
		currentDirectory = currentDirectory.substring(0,lastSeparatorIndex);

		setPath(currentDirectory);
	    }

	    // new drive selection
	    else if(theAction.equals("DRIVE")) {
		File testDrive = new File((String )comboBox.getSelectedItem());
		if(testDrive.exists()) {
		    currentDirectory = (String )comboBox.getSelectedItem();		
		    setPath(currentDirectory);
		}
	    }

	    // creation of new folder
	    else if(theAction.equals("CREATE")) {


		Text theText = new Text(owner);
		int lastSeparatorIndex = currentDirectory.lastIndexOf(File.separator);
		int firstSeparatorIndex = currentDirectory.indexOf(File.separator);
		String separator = File.separator;
		if((lastSeparatorIndex == firstSeparatorIndex)&&
		   (firstSeparatorIndex == currentDirectory.length() -1)) {
		    separator = "";
		}
		new File(currentDirectory + separator + theText.text.getText()).mkdir();
		setPath(currentDirectory);
		

	    }
	    // ok action
	    else if(theAction.equals("OK")) {
		setVisible(false);
	    }
	    
	    // cancel action
	    else {
		zipTable.clearSelection();
		canceled = true;
		setVisible(false);
		
	    }
	}
    }
    /**
     * Class use to enter the name of the new folder
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    private class Text extends JDialog implements ActionListener {

	// public member
	public JTextField text;

	/**
	 * Constructor of the textfield
	 * @param owner frame which instanciate this dialog
	 */
	public Text(Frame owner) {
	    super(owner,"New Folder",true);
	    text = new JTextField(30);
	    text.addActionListener(this);
	    getContentPane().add(text);
	    pack();
	    Dimension dim = owner.getSize();
	    Point loc = owner.getLocation();
	    Dimension curdim = getSize();
	    setLocation(loc.x + dim.width/2 - curdim.width/2, loc.y + dim.height/2 - curdim.height/2);
	    setVisible(true);
	}

	/**
	 * Called when the ENTER key is enfonced
	 * @param e the action event
	 */
	public void actionPerformed(ActionEvent e) {
	    setVisible(false);
	}
    }



    /**
     * Class used to listen the mouse action
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    private class MouseListener extends MouseAdapter {

	/**
	 * Called when mouse button are clicked, enter in the clicked directory
	 * @param e the mouse event
	 */
	public void mouseClicked(MouseEvent e) {

	    // double click with left or right button
	    if (e.getClickCount() == 2) {
		int index = zipTable.getSelectedRow();
		if(index != -1) {
		    Vector row = (Vector )files.elementAt(index);
		    String type = (String )row.elementAt(1);
		    if( type.equals("directory") ) {
			int lastSeparatorIndex = currentDirectory.lastIndexOf(File.separator);
			int firstSeparatorIndex = currentDirectory.indexOf(File.separator);
			String separator = File.separator;
			if((lastSeparatorIndex == firstSeparatorIndex)&&
			   (firstSeparatorIndex == currentDirectory.length() -1)) {
			    separator = "";
			}
			currentDirectory = currentDirectory + separator + (String) row.elementAt(0);
			setPath(currentDirectory);
		    }
		}
	    }
	}
    }


    /**
     * Method return the selected directory
     * @return the path + file name
     */
    public String getSelectedDirectory() {
	int index;
	if((index = zipTable.getSelectedRow()) != -1) {
	    int lastSeparatorIndex = currentDirectory.lastIndexOf(File.separator);
	    int firstSeparatorIndex = currentDirectory.indexOf(File.separator);
	    String separator = File.separator;
	    if((lastSeparatorIndex == firstSeparatorIndex)&&
	       (firstSeparatorIndex == currentDirectory.length() -1)) {
		separator = "";
	    }
	    return currentDirectory + separator + (String)((Vector)files.elementAt(index)).elementAt(0);
	}
	else {
	    return currentDirectory;
	}
    }
}
